<?php
session_start();

// 检查用户是否已登录
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// 上传目录
$uploadDir = 'uploads/';

// 动态生成基础 URL
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$baseUrl = $protocol . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/\\') . '/uploads/';

// 处理删除图片请求
if (isset($_GET['delete'])) {
    $fileName = basename($_GET['delete']);
    $fileToDelete = $uploadDir . $fileName;

    if (file_exists($fileToDelete)) {
        if (unlink($fileToDelete)) {
            // 重定向回当前页面并移除URL参数
            header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
            exit;
        } else {
            $deleteError = "删除文件时出现未知错误，请稍后重试。";
        }
    } else {
        $deleteError = "要删除的文件不存在。";
    }
}

// 获取上传目录下的所有图片文件
$imageFiles = [];
$files = scandir($uploadDir);
foreach ($files as $file) {
    if ($file != '.' && $file != '..') {
        $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])) {
            $imageFiles[] = $file;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>图片管理</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">图片管理</h1>
        <?php if (isset($deleteError)): ?>
            <div class="alert alert-danger">
                <?php echo $deleteError; ?>
            </div>
        <?php endif; ?>
        <div class="row">
            <?php if (!empty($imageFiles)): ?>
                <?php foreach ($imageFiles as $imageFile): ?>
                    <?php $imageUrl = $baseUrl . $imageFile; ?>
                    <div class="col-md-4 mb-4">
                        <div class="card">
                            <img src="<?php echo $imageUrl; ?>" class="card-img-top" alt="<?php echo htmlspecialchars($imageFile); ?>">
                            <div class="card-body">
                                <p class="card-text"><?php echo htmlspecialchars($imageFile); ?></p>
                                <button class="btn btn-primary btn-sm" onclick="copyImageUrl('<?php echo $imageUrl; ?>')">复制链接</button>
                                <button class="btn btn-danger btn-sm" onclick="if(confirm('确定要删除这张图片吗？')) { window.location.href='?delete=<?php echo urlencode($imageFile); ?>' }">
                                    删除图片
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col">
                    <p class="text-center">暂无上传的图片。</p>
                </div>
            <?php endif; ?>
        </div>
        <div class="text-center mt-3">
            <a href="upload.php" class="btn btn-primary">返回上传页面</a>
            <a href="logout.php" class="btn btn-secondary">注销登录</a>
        </div>
    </div>

    <script>
        function copyImageUrl(url) {
            navigator.clipboard.writeText(url).then(function() {
                alert("图片链接已复制到剪贴板：" + url);
            }).catch(function() {
                var tempInput = document.createElement("input");
                tempInput.value = url;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand("copy");
                document.body.removeChild(tempInput);
                alert("图片链接已复制到剪贴板：" + url);
            });
        }
    </script>
</body>

</html>