<?php
session_start();

if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $usersFile = 'users.json';
    $users = json_decode(file_get_contents($usersFile), true);
    $username = $_SESSION['username'];

    $currentPassword = $_POST['current_password'];
    $newPassword = $_POST['new_password'];
    $confirmPassword = $_POST['confirm_password'];

    if (isset($users[$username]) && $users[$username] === $currentPassword) {
        if ($newPassword === $confirmPassword) {
            $users[$username] = $newPassword;
            file_put_contents($usersFile, json_encode($users, JSON_PRETTY_PRINT));
            header("Location: change_password.php?status=success");
            exit;
        } else {
            header("Location: change_password.php?status=error&msg=" . urlencode("新密码和确认密码不匹配"));
            exit;
        }
    } else {
        header("Location: change_password.php?status=error&msg=" . urlencode("当前密码不正确"));
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>修改密码</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }

        .container {
            max-width: 500px;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">修改密码</h1>
        <?php if (isset($_GET['status'])):
            if ($_GET['status'] == 'success'): ?>
                <div class="alert alert-success">密码修改成功</div>
            <?php elseif ($_GET['status'] == 'error'): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars(urldecode($_GET['msg'])); ?></div>
        <?php endif; endif; ?>
        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
            <div class="mb-3">
                <label for="current_password" class="form-label">当前密码</label>
                <input type="password" name="current_password" id="current_password" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="new_password" class="form-label">新密码</label>
                <input type="password" name="new_password" id="new_password" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="confirm_password" class="form-label">确认新密码</label>
                <input type="password" name="confirm_password" id="confirm_password" class="form-control" required>
            </div>
            <div class="text-center">
                <button type="submit" class="btn btn-primary">修改密码</button>
            </div>
        </form>
        <div class="text-center mt-3">
            <a href="upload.php" class="btn btn-secondary">返回上传页面</a>
        </div>
    </div>
</body>

</html>