<?php
session_start();

$usersFile = 'users.json';
if (!file_exists($usersFile)) {
    // If the users.json file does not exist, create it with a default user
    $defaultUsers = [
        'admin' => 'admin000'
    ];
    file_put_contents($usersFile, json_encode($defaultUsers, JSON_PRETTY_PRINT));
}

$users = json_decode(file_get_contents($usersFile), true);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];

    if (isset($users[$username]) && $users[$username] === $password) {
        $_SESSION['is_logged_in'] = true;
        $_SESSION['username'] = $username;
        header("Location: upload.php");
        exit;
    } else {
        $error = "用户名或密码错误";
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>登录</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }

        .container {
            max-width: 400px;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">登录</h1>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
            <div class="mb-3">
                <input type="text" name="username" class="form-control" placeholder="用户名" required>
            </div>
            <div class="mb-3">
                <input type="password" name="password" class="form-control" placeholder="密码" required>
            </div>
            <div class="text-center">
                <button type="submit" class="btn btn-primary">登录</button>
            </div>
        </form>
    </div>
</body>

</html>