<?php
session_start();

// 检查用户是否已登录
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// 上传目录
$uploadDir = 'uploads/';

// 检查上传目录是否存在，如果不存在则创建
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// 处理文件上传
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    $file = $_FILES['image'];
    $errorMessage = '';
    $uploadSuccess = false;

    // 允许上传的文件类型
    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
    $validExtensions = ['jpg', 'jpeg', 'png', 'gif'];
    $maxFileSize = 5 * 1024 * 1024; // 5MB

    if ($file['error'] === UPLOAD_ERR_OK) {
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if (in_array($file['type'], $allowedTypes) && in_array($ext, $validExtensions)) {
            if ($file['size'] <= $maxFileSize) {
                if (getimagesize($file['tmp_name'])) {
                    $fileName = uniqid() . '.' . $ext;
                    $filePath = $uploadDir . $fileName;

                    if (move_uploaded_file($file['tmp_name'], $filePath)) {
                        // 动态生成基础 URL
                        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
                        $baseUrl = $protocol . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/\\') . '/uploads/';
                        $imageUrl = $baseUrl . $fileName;
                        
                        // 重定向以防止表单重复提交
                        header("Location: upload.php?status=success&url=" . urlencode($imageUrl));
                        exit;
                    } else {
                        $errorMessage = '图片上传失败，请稍后重试';
                    }
                } else {
                    $errorMessage = '上传的文件不是有效的图片';
                }
            } else {
                $errorMessage = '文件大小超过限制，最大允许 5MB';
            }
        } else {
            $errorMessage = '不允许上传该类型的文件，请上传 JPEG、PNG 或 GIF 格式的图片';
        }
    } else {
        $errorMessage = '文件上传出错，错误代码：' . $file['error'];
    }

    // 如果有错误，重定向并显示错误信息
    header("Location: upload.php?status=error&msg=" . urlencode($errorMessage));
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>图片上传</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }

        .container {
            max-width: 600px;
        }

        #drop-zone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            padding: 25px;
            text-align: center;
            cursor: pointer;
            color: #007bff;
            margin-bottom: 20px;
        }

        #drop-zone.dragover {
            background-color: #e9ecef;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">图片上传</h1>
        
        <?php if (isset($_GET['status'])): ?>
            <?php if ($_GET['status'] == 'success'): ?>
                <div class="alert alert-success">上传成功！</div>
                <div class="mb-3">
                    <img src="<?php echo htmlspecialchars(urldecode($_GET['url'])); ?>" alt="Uploaded Image" class="img-fluid">
                </div>
                <div class="input-group mb-3">
                    <input type="text" id="image-url" class="form-control" value="<?php echo htmlspecialchars(urldecode($_GET['url'])); ?>" readonly>
                    <button class="btn btn-outline-secondary" type="button" id="copy-button">复制链接</button>
                </div>
            <?php elseif ($_GET['status'] == 'error'): ?>
                <div class="alert alert-danger">
                    <?php echo htmlspecialchars(urldecode($_GET['msg'])); ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <form action="upload.php" method="post" enctype="multipart/form-data" id="upload-form">
            <div id="drop-zone">
                拖拽图片到这里，或点击选择文件
                <input type="file" name="image" accept="image/jpeg, image/png, image/gif" class="d-none" id="file-input">
            </div>
            <div class="text-center">
                <button type="submit" class="btn btn-primary">上传图片</button>
            </div>
        </form>
        <div class="text-center mt-3">
            <a href="123.php" class="btn btn-info">查看上传图片</a>
            <a href="change_password.php" class="btn btn-warning">修改密码</a>
            <a href="logout.php" class="btn btn-secondary">注销登录</a>
        </div>
    </div>

    <script>
        const dropZone = document.getElementById('drop-zone');
        const fileInput = document.getElementById('file-input');
        const uploadForm = document.getElementById('upload-form');

        dropZone.addEventListener('click', () => fileInput.click());

        dropZone.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropZone.classList.add('dragover');
        });

        dropZone.addEventListener('dragleave', () => {
            dropZone.classList.remove('dragover');
        });

        dropZone.addEventListener('drop', (e) => {
            e.preventDefault();
            dropZone.classList.remove('dragover');
            const files = e.dataTransfer.files;
            if (files.length > 0) {
                fileInput.files = files;
                // 触发表单提交
                uploadForm.dispatchEvent(new Event('submit', { bubbles: true, cancelable: true }));
            }
        });
        
        // 监听表单提交事件，确保拖拽上传也能触发
        uploadForm.addEventListener('submit', function() {
            // 可以在这里添加一个加载指示器
        });

        const copyButton = document.getElementById('copy-button');
        if (copyButton) {
            copyButton.addEventListener('click', () => {
                const imageUrl = document.getElementById('image-url');
                imageUrl.select();
                navigator.clipboard.writeText(imageUrl.value).then(() => {
                    alert('链接已复制到剪贴板');
                });
            });
        }
    </script>
</body>

</html>
